<?php
/**
* Partial that generates the markup for a hidden input.
*
* This partial generates the markup used by the {@link Field_markup_generator::field_markup() field_markup()} method.  For the partial 
* used by {@link Field_markup_generator::markup() markup()}, see {@link _hidden.php}.  
*
* Form markup generator partials are designed to follow object-oriented-esque patterns of inheritance.  This partial will by default be used by the 
* {@link Hidden_markup_generator} and all of its children that do not have a partial named after their {@link Hidden_markup_generator::$_type type}.
* If you wish to override this partial in your application, please follow the instructions in the "Partials and Markup Generation" section of the
* {@link Field_markup_generator} class documentation.
*
* Like all {@link Field_markup_generator} partials, this partial expects to be passed a copy of the markup generator calling it, called $markup_generator.
* @package icarus
* @subpackage form-markup-generator
*
* @author M. Gibbs <gibbs_margaret@bah.com> Last updated 2012-08-02
*/
if(!isset($markup_generator) || !is_a($markup_generator, 'Field_markup_generator'))
	$this->error_helper->should_be_a_field_markup_generator($markup_generator);

$attributes = array_merge($markup_generator->attributes(), array('type' => 'hidden','name' => $markup_generator->name_for_markup(), 'value' => htmlspecialchars($markup_generator->raw_value)));

echo '<input'.attributes_to_string($attributes).' />';

?>